#version 330
#extension GL_EXT_gpu_shader4 : enable
//Mandala PlaygroundMod01.fsh  by   xx3000
//https://www.shadertoy.com/view/tlfXR8
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159265

#define REFLECTION_PLANES 6.0

// cosine based palette, by iq
vec3 palette( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b*cos( 6.28318*(c*t+d) );
}

vec3 smoothTransition(vec3 a, vec3 b, vec3 c, float t)
{
    float p = fract(t);
    int id = int(mod(t, 3.0));
    
    vec3 outCol = vec3(0,0,0);
    switch (id)
    {
        case 0:
            outCol = mix(a,b,smoothstep(0.0,1.0,p));
            break;
        case 1:
            outCol = mix(b,c,smoothstep(0.0,1.0,p));
            break;
        case 2:
            outCol = mix(c,a,smoothstep(0.0,1.0,p));
            break;
    }
    
    return outCol;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float line = 0.5;
    float yshift = 0.0;  //0.2
    float xshift = 0.3; //0.5 //0.05
    
    vec3 white = vec3(1.0,1.0,1.0);
    
    vec2 uv = gl_FragCoord.xy/iResolution.y;

    vec3 col = vec3(1.0,1.0,1.0);
    
    
    {
        uv -= vec2(0.5*iResolution.x/iResolution.y,0.5);


        float centerrepeat = 2.0*PI/REFLECTION_PLANES;

        float repeat = 2.0;

        vec2 ipol = vec2(atan(uv.y,uv.x),length(uv));

        ipol.x = abs(mod(ipol.x,centerrepeat)-centerrepeat*0.5);

        uv = vec2(ipol.y*cos(ipol.x),ipol.y*sin(ipol.x));

        vec4 bg1= vec4(palette((1.0-(ipol.y)+iTime*0.25),vec3(0.8, 0.5, 0.4),vec3(0.2, 0.4, 0.2),vec3(2.0, 1.0, 1.0),vec3(0.00, 0.25, 0.25)),1.0);

        uv*=7.0;    

        uv+=vec2(-iTime*xshift,iTime*yshift);

        uv.x= abs(mod(uv.x,repeat)-repeat*0.5);

        uv.y= abs(mod(uv.y,repeat)-repeat*0.5);

        vec2 coord = vec2(uv.y,uv.x);
        vec2 polar = vec2(atan(uv.y,uv.x),length(uv));

        coord = mix(coord, polar,sin(iTime)*0.5+0.5);

        vec3 pre1 = vec3(1.0,1.0,1.0)*polar.y*0.2;
        vec3 pre2 = palette((1.0-(polar.y)+iTime*0.05),vec3(0.2, 0.2, 0.2),vec3(0.5),vec3(2.0, 1.0, 1.0),vec3(0.00, 0.33, 0.67));

        float res = sin(6.0*coord.x+iTime*1.0) * (iMouse.x/iResolution.x) + (3.0 * iMouse.y/iResolution.y);
            
        vec3 col1 = mix(bg1.xyz,pre1,abs(abs(res-coord.y)-line));
        vec3 col2 = mix(bg1.xyz,pre2,abs(abs(res-coord.y)-line));
        vec3 col3  = texture2D( iChannel0, col1.x * 0.12 + coord*0.15 ).xyz;
        col = smoothTransition(col1,col2, col3,iTime * 0.2);
    }
    
    gl_FragColor = vec4(col,1.0);
}